/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DecimalTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DecimalType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class DecimalTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    DecimalTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(DecimalType decimalType) {
        DecimalTypeMutatorProvider mutatorProvider = new DecimalTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)decimalType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)decimalType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new DecimalType(), new DecimalType(1.2), new DecimalType(0.0), new DecimalType(0L), new DecimalType("-4.3")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

