/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DateTimeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class DateTimeTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    DateTimeTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(DateTimeType dtt) {
        DateTimeTypeMutatorProvider mutatorProvider = new DateTimeTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)dtt));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)dtt));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new DateTimeType(), new DateTimeType(new Date()), new DateTimeType(new Date()).setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true)))), new DateTimeType(new Date(), TemporalPrecisionEnum.MILLI)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

