/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContributorMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ContributorMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ContributorMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Contributor contributor) {
        ContributorMutatorProvider mutatorProvider = new ContributorMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contributor));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contributor));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Contributor(), new Contributor().setName("Fuzzer"), new Contributor().setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing"))), new Contributor().setContact(List.of(new ContactDetail().setName("Fuzzer")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

