/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContactPointMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ContactPointMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ContactPointMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(ContactPoint contactPoint) {
        ContactPointMutatorProvider mutatorProvider = new ContactPointMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contactPoint));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contactPoint));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new ContactPoint(), new ContactPoint().setRank(0).setValue("fuzzy"), new ContactPoint().setRank(0).setValue("fuzzy").setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true)))), new ContactPoint().setUse(ContactPoint.ContactPointUse.HOME), new ContactPoint().setUse(ContactPoint.ContactPointUse.HOME).setSystem(ContactPoint.ContactPointSystem.FAX)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

