/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContactDetailMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ContactDetailMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ContactDetailMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(ContactDetail contactDetail) {
        ContactDetailMutatorProvider mutatorProvider = new ContactDetailMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contactDetail));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)contactDetail));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new ContactDetail(), new ContactDetail().setName("Fuzzer"), new ContactDetail().setTelecom(List.of(new ContactPoint())), new ContactDetail().setName("Fuzzer").setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

