/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodingMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class CodingMutatorProviderTest
extends FhirFuzzingMutatorTest {
    CodingMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Coding coding) {
        CodingMutatorProvider mutatorProvider = new CodingMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)coding));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)coding));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Coding(), new Coding().setCode("fuzzing"), new Coding().setCode("fuzzing").setDisplay("Fuzzing Display"), new Coding().setCode("fuzzing").setDisplay("Fuzzing Display").setSystem("https://gematik.de/fhir/fuzzing")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

