/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodeableConceptTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class CodeableConceptTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    CodeableConceptTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(CodeableConcept codeableConcept) {
        CodeableConceptTypeMutatorProvider mutatorProvider = new CodeableConceptTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)codeableConcept));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)codeableConcept));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new CodeableConcept(), new CodeableConcept().addCoding(new Coding("system", "code", "display"))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

