/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class CodeTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    CodeTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(CodeType codeType) {
        CodeTypeMutatorProvider mutatorProvider = new CodeTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)codeType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)codeType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new CodeType(), new CodeType("ABC"), new CodeType("XYZ").setSystem("https://gematik.de/fhir/fuzzing"), new CodeType("XYZ").setExtension(List.of(new Extension()))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

