/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CanonicalTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class CanonicalTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    CanonicalTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(CanonicalType canonicalType) {
        CanonicalTypeMutatorProvider mutatorProvider = new CanonicalTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)canonicalType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)canonicalType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new CanonicalType(), new CanonicalType().setValue((Object)"Fuzzing"), new CanonicalType().setExtension(List.of(new Extension().setValue((Type)new Coding("system", "code", "display"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

