/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.BooleanTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class BooleanTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    BooleanTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(BooleanType booleanType) {
        BooleanTypeMutatorProvider mutatorProvider = new BooleanTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)booleanType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)booleanType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new BooleanType(true), new BooleanType(false), new BooleanType().setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

