/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.Base64BinaryTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class Base64BinaryTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    Base64BinaryTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Base64BinaryType b64bt) {
        Base64BinaryTypeMutatorProvider mutatorProvider = new Base64BinaryTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)b64bt));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)b64bt));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Base64BinaryType(), new Base64BinaryType("Hello World"), new Base64BinaryType("Fuzzing").setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

