/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.AttachmentMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.Date;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Attachment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class AttachmentMutatorProviderTest
extends FhirFuzzingMutatorTest {
    AttachmentMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Attachment attachment) {
        AttachmentMutatorProvider mutatorProvider = new AttachmentMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)attachment));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)attachment));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Attachment(), new Attachment().setContentType("application/json"), new Attachment().setCreation(new Date()), new Attachment().setData("Hello world".getBytes()), new Attachment().setHash("hash".getBytes()), new Attachment().setSize(123), new Attachment().setTitle("fuzzing test")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

