/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.AnnotationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class AnnotationMutatorProviderTest
extends FhirFuzzingMutatorTest {
    AnnotationMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Annotation annotation) {
        AnnotationMutatorProvider mutatorProvider = new AnnotationMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)annotation));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)annotation));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Annotation(), new Annotation().setAuthor((Type)new StringType("Fuzzer")), new Annotation().setAuthor((Type)new StringType("Fuzzer")).setText("Fuzzy text")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

