/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SubscriptionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Subscription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SubscriptionMutatorProviderTest
extends FhirFuzzingMutatorTest {
    SubscriptionMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Subscription subscription = (Subscription)this.fhirCodec.decode(Subscription.class, content);
        SubscriptionMutatorProvider mutatorProvider = new SubscriptionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)subscription));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)subscription));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7/subscription", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

