/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MedicationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MedicationMutatorProviderTest
extends FhirFuzzingMutatorTest {
    MedicationMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        Medication medication = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Medication)).map(resource -> (Medication)resource).findFirst().orElseThrow();
        MedicationMutatorProvider mutatorProvider = new MedicationMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)medication));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)medication));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        List ciBundles = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle", (boolean)true);
        List kbvBundles = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.0.2/bundle", (boolean)true);
        return Stream.concat(ciBundles.stream(), kbvBundles.stream()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

