/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MedicationDispenseMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MedicationDispenseMutatorProviderTest
extends FhirFuzzingMutatorTest {
    MedicationDispenseMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        MedicationDispense medicationDispense = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.MedicationDispense)).map(resource -> (MedicationDispense)resource).findFirst().orElseThrow();
        MedicationDispenseMutatorProvider mutatorProvider = new MedicationDispenseMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)medicationDispense));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)medicationDispense));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/dav/1.2", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @Test
    void shouldFuzzWithStatusReasonReference() {
        MedicationDispenseMutatorProvider mutatorProvider = new MedicationDispenseMutatorProvider();
        MedicationDispense md = new MedicationDispense();
        String referenceUrl = "https://gematik.de/fhir/fuzzing/123";
        md.setStatusReason((Type)new Reference("https://gematik.de/fhir/fuzzing/123"));
        mutatorProvider.getMutators().forEach(m -> Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)md)));
    }
}

