/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.LocationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LocationMutatorProviderTest
extends FhirFuzzingMutatorTest {
    LocationMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(Location location) {
        LocationMutatorProvider mutatorProvider = new LocationMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)location));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)location));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Location(), new Location().setIdentifier(List.of(new Identifier())), new Location().setDescription("test location")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

