/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.InvoiceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class InvoiceMutatorProviderTest
extends FhirFuzzingMutatorTest {
    InvoiceMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        Invoice invoice = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Invoice)).map(resource -> (Invoice)resource).findFirst().orElseThrow();
        InvoiceMutatorProvider mutatorProvider = new InvoiceMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)invoice));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)invoice));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/dav/1.2", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

