/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.GoalMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class GoalMutatorProviderTest
extends FhirFuzzingMutatorTest {
    GoalMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(Goal goal) {
        GoalMutatorProvider mutatorProvider = new GoalMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)goal));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)goal));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Goal(), new Goal().setIdentifier(List.of(new Identifier())), new Goal().setIdentifier(List.of(new Identifier())).setLifecycleStatus(Goal.GoalLifecycleStatus.CANCELLED), new Goal().setAddresses(List.of(new Reference("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

