/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.DocumentReferenceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DocumentReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DocumentReferenceMutatorProviderTest
extends FhirFuzzingMutatorTest {
    DocumentReferenceMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        DocumentReference documentReference = (DocumentReference)this.fhirCodec.decode(DocumentReference.class, content);
        DocumentReferenceMutatorProvider mutatorProvider = new DocumentReferenceMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)documentReference));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)documentReference));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7/documentreference", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

