/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.DetectedIssueMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DetectedIssueMutatorProviderTest
extends FhirFuzzingMutatorTest {
    DetectedIssueMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        DetectedIssue detectedIssue = (DetectedIssue)this.fhirCodec.decode(DetectedIssue.class, content);
        DetectedIssueMutatorProvider mutatorProvider = new DetectedIssueMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)detectedIssue));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)detectedIssue));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7/detectedissue", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

