/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ConditionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ConditionMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ConditionMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(Condition condition) {
        ConditionMutatorProvider mutatorProvider = new ConditionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)condition));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)condition));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Condition(), new Condition().setIdentifier(List.of(new Identifier())), new Condition().setAsserter(new Reference("Fuzzer"))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

