/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CompositionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CompositionMutatorProviderTest
extends FhirFuzzingMutatorTest {
    CompositionMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        Composition composition = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Composition)).map(resource -> (Composition)resource).findFirst().orElseThrow();
        CompositionMutatorProvider mutatorProvider = new CompositionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        List ciBundles = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle", (boolean)true);
        List kbvBundles = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.0.2/bundle", (boolean)true);
        return Stream.concat(ciBundles.stream(), kbvBundles.stream()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowOnEmptyComposition(Composition composition) {
        CompositionMutatorProvider mutatorProvider = new CompositionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
        });
    }

    static Stream<Arguments> shouldNotThrowOnEmptyComposition() {
        return Stream.of(new Composition(), new Composition().setAuthor(List.of()), new Composition().setAuthor(new ArrayList()), new Composition().setCategory(new ArrayList()), new Composition().setAttester(new ArrayList())).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldNotThrowOnEmptyComposition"})
    void shouldNotThrowOnEmptyCompositionWithoutSections(Composition composition) {
        CompositionMutatorProvider mutatorProvider = new CompositionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
            composition.setSection(new LinkedList());
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)composition));
        });
    }
}

