/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ChargeItemMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ChargeItemMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ChargeItemMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        ChargeItem chargeItem = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.ChargeItem)).map(resource -> (ChargeItem)resource).findFirst().orElseThrow();
        ChargeItemMutatorProvider mutatorProvider = new ChargeItemMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)chargeItem));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)chargeItem));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/erx/1.2.0/chargeitembundle", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

