/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BinaryMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class BinaryMutatorProviderTest
extends FhirFuzzingMutatorTest {
    BinaryMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldNotThrowAnything(File f) {
        String content = ResourceLoader.readString((File)f);
        Bundle bundle = (Bundle)this.fhirCodec.decode(Bundle.class, content);
        Binary binary = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Binary)).map(resource -> (Binary)resource).findFirst().orElseThrow();
        BinaryMutatorProvider mutatorProvider = new BinaryMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)binary));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)binary));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/erx/1.2.0/receiptbundle", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldFuzzEmptyBinaries(Binary binary) {
        BinaryMutatorProvider mutatorProvider = new BinaryMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)binary)));
    }

    static Stream<Arguments> shouldFuzzEmptyBinaries() {
        return Stream.of(new Binary(), new Binary().setData("".getBytes()), new Binary().setData(null), new Binary().setData("hello".getBytes()), new Binary().setData("SGVsbG9Xb3JsZA==".getBytes()), new Binary().setContent("".getBytes()), new Binary().setContent("hello".getBytes()), new Binary().setContent("SGVsbG9Xb3JsZA==".getBytes())).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

