/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive;

import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive.PrimitiveUriMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class PrimitiveUriMutatorProviderTest
extends FhirFuzzingMutatorTest {
    PrimitiveUriMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(String url) {
        PrimitiveUriMutatorProvider mutatorProvider = new PrimitiveUriMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            PrimitiveTypeFuzzingResponse out = (PrimitiveTypeFuzzingResponse)Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)url));
            String fuzzed = (String)out.getFuzzedValue();
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)fuzzed));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of("https://gematik.de/fhir/fuzzing", "http://gematik.de/fhir/fuzzing", "gematik.de/fhir/fuzzing", "not an url", "", "Medication/88c4029f-dfab-415a-b6de-64fd1a4058e6").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

