/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl;

import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntryType;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FuzzingContextImplTest
extends FhirFuzzingMutatorTest {
    FuzzingContextImplTest() {
    }

    @Test
    void shouldResponseWithNoopOnNullType01() {
        Type type = null;
        FuzzingLogEntry fle = this.ctx.fuzzChild("test", type);
        Assertions.assertEquals((Object)FuzzingLogEntryType.NOOP, (Object)fle.getType());
    }

    @Test
    void shouldResponseWithNoopOnNullType02() {
        Type type = null;
        FuzzingLogEntry fle = this.ctx.fuzzChild(Bundle.class, type);
        Assertions.assertEquals((Object)FuzzingLogEntryType.NOOP, (Object)fle.getType());
    }

    @Test
    void shouldResponseWithNoopOnNullType03() {
        Type type = null;
        FuzzingLogEntry fle = this.ctx.fuzzIdElement(DateTimeType.class, type);
        Assertions.assertEquals((Object)FuzzingLogEntryType.NOOP, (Object)fle.getType());
    }

    @Test
    void shouldResponseWithNoopOnNullType04() {
        Resource bundle = null;
        FuzzingLogEntry fle = this.ctx.fuzzIdElement(Bundle.class, bundle);
        Assertions.assertEquals((Object)FuzzingLogEntryType.NOOP, (Object)fle.getType());
    }

    @Test
    void shouldResponseWithNoopOnBundleWithoutResources() {
        Bundle bundle = new Bundle();
        FuzzingLogEntry fle = this.ctx.fuzzChildResources(bundle);
        Assertions.assertEquals((Object)FuzzingLogEntryType.NOOP, (Object)fle.getType());
    }

    @Test
    void shouldFuzzDeeplyInheritedResources() {
        MyBundleThree deepBundle = new MyBundleThree();
        List fle = (List)Assertions.assertDoesNotThrow(() -> this.ctx.startFuzzingSession((Resource)deepBundle));
        Assertions.assertFalse((boolean)fle.isEmpty());
    }

    @Test
    void shouldFuzzDeeplyInheritedTypes() {
        MyDateTimeTypeThree deepType = new MyDateTimeTypeThree();
        FuzzingLogEntry fle = (FuzzingLogEntry)Assertions.assertDoesNotThrow(() -> this.ctx.fuzzChild("test", (Type)deepType));
        Assertions.assertNotNull((Object)fle);
    }

    static class MyBundleThree
    extends MyBundleTwo {
        MyBundleThree() {
        }
    }

    static class MyDateTimeTypeThree
    extends MyDateTimeTypeTwo {
        @Generated
        public MyDateTimeTypeThree() {
        }
    }

    static class MyDateTimeTypeTwo
    extends MyDateTimeTypeOne {
        @Generated
        public MyDateTimeTypeTwo() {
        }
    }

    static class MyDateTimeTypeOne
    extends DateTimeType {
        @Generated
        public MyDateTimeTypeOne() {
        }
    }

    static class MyBundleTwo
    extends MyBundleOne {
        MyBundleTwo() {
        }
    }

    static class MyBundleOne
    extends Bundle {
        MyBundleOne() {
        }
    }
}

