/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import de.gematik.bbriccs.fhir.codec.utils.FhirTest;
import de.gematik.bbriccs.fhir.fuzzing.FhirResourceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingEngine;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveType;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import de.gematik.bbriccs.fhir.fuzzing.impl.FuzzingEngineImpl;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingSessionLogbook;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BundleMutatorProvider;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class FhirFuzzingEngineTest
extends FhirTest {
    private static final FhirCodec staticFhirCodec = FhirCodec.forR4().disableErrors().andDummyValidator();
    private boolean withDebug;

    FhirFuzzingEngineTest() {
    }

    protected void initialize() {
        this.fhirCodec = staticFhirCodec;
        this.withDebug = false;
        this.printEncoded = false;
        this.prettyPrint = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource
    void shouldFuzzErpExamples(File file) {
        String content = ResourceLoader.readString((File)file);
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)0.1).withDefaultFuzzers().build();
        Resource resource = this.fhirCodec.decode(content);
        if (this.withDebug) {
            try {
                fuzzer.fuzz(resource);
            }
            catch (Exception e) {
                Assertions.fail((String)e.getMessage());
            }
            finally {
                this.printFuzzingLog(fuzzer.getLastSessionLog());
            }
        } else {
            Assertions.assertDoesNotThrow(() -> fuzzer.fuzz(resource));
            Assertions.assertDoesNotThrow(() -> this.fhirCodec.encode((IBaseResource)resource, this.encodingType, this.prettyPrint));
        }
        if (this.printEncoded) {
            this.printResource(resource);
        }
    }

    static Stream<Arguments> shouldFuzzErpExamples() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldFuzzFromThinAir(Resource resource) {
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).withDefaultFuzzers().build();
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz(resource));
        Assertions.assertDoesNotThrow(() -> ((FuzzingEngine)fuzzer).getLastSessionLog());
        if (this.withDebug) {
            this.printFuzzingLog(fuzzer.getLastSessionLog());
        }
        if (this.printEncoded) {
            this.printResource(resource);
        }
    }

    static Stream<Arguments> shouldFuzzFromThinAir() {
        return Stream.of(new Bundle(), new Bundle().addEntry(new Bundle.BundleEntryComponent().setResource((Resource)new Medication())), new Task(), new MedicationDispense(), new Medication()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldRegisterCustomResourceMutator(File file) {
        String content = ResourceLoader.readString((File)file);
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).registerResourceFuzzer(MyBundle.class, MockBundleMutatorProvider::new).registerResourceMutator(MyBundle.class, MockBundleMutatorProvider.getMockMutator()).build();
        MyBundle resource = (MyBundle)this.fhirCodec.decode(MyBundle.class, content);
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        Assertions.assertTrue((MockBundleMutatorProvider.callCounter > 0 ? 1 : 0) != 0);
    }

    static Stream<Arguments> shouldRegisterCustomResourceMutator() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldRegisterCustomTypeMutator(File file) {
        String content = ResourceLoader.readString((File)file);
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).registerResourceFuzzer(Bundle.class, BundleMutatorProvider::new).registerTypeFuzzer(Identifier.class, MockIdentifierMutatorProvider::new).registerTypeMutator(Identifier.class, MockIdentifierMutatorProvider.getMockMutator()).build();
        MyBundle resource = (MyBundle)this.fhirCodec.decode(MyBundle.class, content);
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        Assertions.assertTrue((MockIdentifierMutatorProvider.callCounter > 0 ? 1 : 0) != 0);
    }

    static Stream<Arguments> shouldRegisterCustomTypeMutator() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldRegisterCustomPrimitiveMutator(File file) {
        String content = ResourceLoader.readString((File)file);
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).withDefaultFuzzers().registerPrimitiveTypeFuzzer((PrimitiveType)PrimitiveStringTypes.URI, MockPrimitivStringMutator::new).registerPrimitiveMutator((PrimitiveType)PrimitiveStringTypes.URI, MockPrimitivStringMutator.getMockMutator()).build();
        MyBundle resource = (MyBundle)this.fhirCodec.decode(MyBundle.class, content);
        Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        Assertions.assertTrue((MockPrimitivStringMutator.callCounter > 0 ? 1 : 0) != 0);
    }

    static Stream<Arguments> shouldRegisterCustomPrimitiveMutator() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @Test
    void shouldCatchMutatorErrors01() {
        FuzzingMutator mutator = (ctx, id) -> FuzzingLogEntry.noop((String)("Exception: " + 7 / 0));
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).registerResourceFuzzer(Bundle.class, BundleMutatorProvider::new).registerTypeFuzzer(Identifier.class, MockIdentifierMutatorProvider::new).registerTypeMutator(Identifier.class, mutator).build();
        Bundle resource = new Bundle();
        resource.setIdentifier(new Identifier());
        FuzzingSessionLogbook logEntry = (FuzzingSessionLogbook)Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        if (this.withDebug) {
            this.printFuzzingLog(logEntry);
        }
    }

    @Test
    void shouldCatchMutatorErrors02() {
        FuzzingMutator mutator = (ctx, id) -> FuzzingLogEntry.noop((String)("Exception: " + 7 / 0));
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).registerResourceFuzzer(Bundle.class, BundleMutatorProvider::new).registerResourceMutator(Bundle.class, mutator).build();
        Bundle resource = new Bundle();
        resource.setIdentifier(new Identifier());
        FuzzingSessionLogbook logEntry = (FuzzingSessionLogbook)Assertions.assertDoesNotThrow(() -> fuzzer.fuzz((Resource)resource));
        if (this.withDebug) {
            this.printFuzzingLog(logEntry);
        }
    }

    @Test
    void shouldThrowOnRegisteringResourceMutatorWithoutFuzzer() {
        FuzzingEngineImpl.Builder fuzzerBuilder = FuzzingEngineImpl.builder((double)1.0);
        FuzzingMutator<MyBundle> mutator = MockBundleMutatorProvider.getMockMutator();
        Assertions.assertThrows(FuzzerException.class, () -> fuzzerBuilder.registerResourceMutator(MyBundle.class, mutator));
    }

    @Test
    void shouldThrowOnRegisteringTypeMutatorWithoutFuzzer() {
        FuzzingEngineImpl.Builder fuzzerBuilder = FuzzingEngineImpl.builder((double)1.0);
        FuzzingMutator<Identifier> mutator = MockIdentifierMutatorProvider.getMockMutator();
        Assertions.assertThrows(FuzzerException.class, () -> fuzzerBuilder.registerTypeMutator(Identifier.class, mutator));
    }

    @Test
    void shouldThrowOnRegisteringPrimitiveMutatorWithoutFuzzer() {
        FuzzingEngineImpl.Builder fuzzerBuilder = FuzzingEngineImpl.builder((double)1.0);
        PrimitiveTypeMutator<String> mutator = MockPrimitivStringMutator.getMockMutator();
        Assertions.assertThrows(FuzzerException.class, () -> fuzzerBuilder.registerPrimitiveMutator((PrimitiveType)PrimitiveStringTypes.URI, mutator));
    }

    @Test
    void shouldThrowOnFuzzingWithoutAnyFuzzers() {
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).build();
        Bundle bundle = new Bundle();
        Assertions.assertThrows(FuzzerException.class, () -> fuzzer.fuzz((Resource)bundle));
    }

    @Test
    void shouldThrowOnFetchingFromEmtpySessionLog() {
        FuzzingEngine fuzzer = FuzzingEngineImpl.builder((double)1.0).build();
        Assertions.assertThrows(FuzzerException.class, () -> ((FuzzingEngine)fuzzer).getLastSessionLog());
        Assertions.assertEquals((int)0, (int)fuzzer.getSessionHistory().size());
    }

    private void printFuzzingLog(FuzzingSessionLogbook sessionLogbook) {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        ObjectWriter writer = this.prettyPrint ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
        String logsOutput = writer.writeValueAsString((Object)sessionLogbook);
        System.out.println(logsOutput);
    }

    public static class MyBundle
    extends Bundle {
    }

    public static class MockBundleMutatorProvider
    implements FhirResourceMutatorProvider<MyBundle> {
        private final List<FuzzingMutator<MyBundle>> mutators = new LinkedList<FuzzingMutator<MyBundle>>();
        private static int callCounter = 0;

        public static FuzzingMutator<MyBundle> getMockMutator() {
            return (ctx, bundle) -> {
                String message = "Call Mock Mutator";
                ++callCounter;
                return FuzzingLogEntry.operation((String)"Call Mock Mutator");
            };
        }

        @Generated
        public List<FuzzingMutator<MyBundle>> getMutators() {
            return this.mutators;
        }
    }

    public static class MockIdentifierMutatorProvider
    implements FhirTypeMutatorProvider<Identifier> {
        private final List<FuzzingMutator<Identifier>> mutators = new LinkedList<FuzzingMutator<Identifier>>();
        public static int callCounter = 0;

        public static FuzzingMutator<Identifier> getMockMutator() {
            return (ctx, bundle) -> {
                String message = "Call Mock Mutator";
                ++callCounter;
                return FuzzingLogEntry.operation((String)"Call Mock Mutator");
            };
        }

        @Generated
        public List<FuzzingMutator<Identifier>> getMutators() {
            return this.mutators;
        }
    }

    public static class MockPrimitivStringMutator
    implements PrimitiveMutatorProvider<String> {
        private final List<PrimitiveTypeMutator<String>> mutators = new LinkedList<PrimitiveTypeMutator<String>>();
        public static int callCounter = 0;

        public static PrimitiveTypeMutator<String> getMockMutator() {
            return (ctx, bundle) -> {
                String message = "Call Mock Mutator";
                ++callCounter;
                return PrimitiveTypeFuzzingResponse.response((Object)"Hello World", (FuzzingLogEntry)FuzzingLogEntry.operation((String)"Call Mock Mutator"));
            };
        }

        @Generated
        public List<PrimitiveTypeMutator<String>> getMutators() {
            return this.mutators;
        }
    }
}

