/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.valueset;

import de.gematik.bbriccs.fhir.coding.FromValueSet;
import de.gematik.bbriccs.fhir.de.HL7CodeSystem;
import lombok.Generated;

public enum ConsentScope implements FromValueSet
{
    RESEARCH("research", "Research", "Consent to participate in research protocol and information sharing required"),
    PATIENT_PRIVACY("patient-privacy", "Privacy Consent", "Agreement to collect, access, use or disclose (share) information"),
    TREATMENT("treatment", "Treatment", "Consent to undergo a specific treatment");

    public static final HL7CodeSystem CODE_SYSTEM;
    private final String code;
    private final String display;
    private final String definition;

    private ConsentScope(String code, String display, String definition) {
        this.code = code;
        this.display = display;
        this.definition = definition;
    }

    public HL7CodeSystem getCodeSystem() {
        return CODE_SYSTEM;
    }

    public static ConsentScope fromCode(String code) {
        return (ConsentScope)FromValueSet.fromCode(ConsentScope.class, (String)code);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDisplay() {
        return this.display;
    }

    @Generated
    public String getDefinition() {
        return this.definition;
    }

    static {
        CODE_SYSTEM = HL7CodeSystem.CONSENT_SCOPE;
    }
}

