/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.bbriccs.fhir.coding.SemanticValue;
import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.coding.exceptions.InvalidSystemException;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import java.text.MessageFormat;
import java.util.Optional;
import org.hl7.fhir.r4.model.Identifier;

public class TelematikID
extends SemanticValue<String, DeBasisProfilNamingSystem> {
    private TelematikID(String telematikId) {
        super((WithSystem)DeBasisProfilNamingSystem.TELEMATIK_ID_SID, (Object)telematikId);
    }

    public static TelematikID random() {
        FakerBrick faker = FakerBrick.getGerman();
        String id = MessageFormat.format("3-SMC-B-Testkarte-{0}", faker.regexify("[0-9]{15}"));
        return TelematikID.from(id);
    }

    public static TelematikID from(String value) {
        return new TelematikID(value);
    }

    public static TelematikID from(Identifier identifier) {
        return Optional.of(identifier).filter(xva$0 -> DeBasisProfilNamingSystem.TELEMATIK_ID_SID.matches(new Identifier[]{xva$0})).map(id -> TelematikID.from(id.getValue())).orElseThrow(() -> new InvalidSystemException(MessageFormat.format("Cannot extract TelematikID from identifier with system {0}", identifier.getSystem())));
    }
}

