/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.bbriccs.fhir.coding.SemanticValue;
import de.gematik.bbriccs.fhir.coding.WithChecksum;
import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilCodeSystem;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;

public class PZN
extends SemanticValue<String, DeBasisProfilCodeSystem>
implements WithChecksum {
    private static final Pattern PZN_PATTERN = Pattern.compile("^\\d{8}$");

    private PZN(String value) {
        super((WithSystem)DeBasisProfilCodeSystem.PZN, (Object)value);
    }

    public boolean isValid() {
        String pzn = (String)this.getValue();
        if (pzn == null) {
            return false;
        }
        Matcher matcher = PZN_PATTERN.matcher(pzn);
        if (!matcher.matches()) {
            return false;
        }
        int calcChecksum = PZN.calcChecksum(pzn);
        if (calcChecksum == 10) {
            return false;
        }
        return this.getChecksum() == calcChecksum;
    }

    public int getChecksum() {
        String value = (String)this.getValue();
        return Character.getNumericValue(value.charAt(value.length() - 1));
    }

    public Coding asCoding() {
        return ((DeBasisProfilCodeSystem)this.getSystem()).asCoding((String)this.getValue());
    }

    public CodeableConcept asNamedCodeable(String drugName) {
        CodeableConcept codeable = new CodeableConcept(this.asCoding());
        codeable.setText(drugName);
        return codeable;
    }

    public CodeableConcept asNamedCodeable() {
        FakerBrick faker = FakerBrick.getGerman();
        return this.asNamedCodeable(faker.medical().medicineName());
    }

    public static PZN from(Coding coding) {
        return PZN.from(coding.getCode());
    }

    public static PZN from(String value) {
        return new PZN(value);
    }

    public static PZN random() {
        String numbers;
        int checkNum;
        FakerBrick faker = FakerBrick.getGerman();
        while ((checkNum = PZN.calcChecksum(numbers = faker.regexify("[0-9]{7}"))) == 10) {
        }
        String value = MessageFormat.format("{0}{1}", numbers, checkNum);
        return PZN.from(value);
    }

    protected static int calcChecksum(String pzn) {
        int sum = 0;
        for (int i = 0; i < 7; ++i) {
            int value = Character.getNumericValue(pzn.charAt(i)) * (i + 1);
            sum += value;
        }
        return sum % 11;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PZN)) {
            return false;
        }
        PZN other = (PZN)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PZN;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

