/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.builder;

import de.gematik.bbriccs.fhir.builder.ElementBuilder;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.HL7StructDef;
import de.gematik.bbriccs.fhir.de.valueset.Country;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StringType;

public class AddressBuilder
extends ElementBuilder<Address, AddressBuilder> {
    private static final Pattern STREET_PATTERN = Pattern.compile("^([\\D\\s]+)\\s*([\\d|\\w]+)?.*");
    private final Address.AddressType addressType;
    private Country country = Country.D;
    private String city;
    private String postal;
    private String street;

    private AddressBuilder(Address.AddressType addressType) {
        this.addressType = addressType;
    }

    public static AddressBuilder ofType(Address.AddressType addressType) {
        return new AddressBuilder(addressType);
    }

    public static AddressBuilder ofPostalType() {
        return AddressBuilder.ofType(Address.AddressType.POSTAL);
    }

    public static AddressBuilder ofPhysicalType() {
        return AddressBuilder.ofType(Address.AddressType.PHYSICAL);
    }

    public static AddressBuilder ofBothTypes() {
        return AddressBuilder.ofType(Address.AddressType.BOTH);
    }

    public AddressBuilder country(Country country) {
        this.country = country;
        return this;
    }

    public AddressBuilder city(String city) {
        this.city = city;
        return this;
    }

    public AddressBuilder postal(String postal) {
        this.postal = postal;
        return this;
    }

    public AddressBuilder street(String street) {
        this.street = street;
        return this;
    }

    public Address build() {
        this.checkRequired();
        Address address = new Address();
        Enumeration type = new Enumeration((EnumFactory)new Address.AddressTypeEnumFactory(), (Enum)this.addressType);
        address.setTypeElement(type);
        address.setCountry(this.country.getCode());
        address.setPostalCode(this.postal).setCity(this.city);
        Matcher streetMatcher = STREET_PATTERN.matcher(this.street);
        if (!streetMatcher.matches()) {
            throw new BuilderException(MessageFormat.format("Given Street {0} is invalid", this.street));
        }
        String streetName = streetMatcher.group(1).trim();
        String houseNumber = streetMatcher.group(2).trim();
        StringType streetLine = address.addLineElement();
        streetLine.setValue((Object)this.street);
        streetLine.addExtension(HL7StructDef.HOUSE_NUMBER.asStringExtension(houseNumber));
        streetLine.addExtension(HL7StructDef.STREET_NAME.asStringExtension(streetName));
        return address;
    }

    private void checkRequired() {
        this.checkRequired((Object)this.country, "AddressBuilder requires a Country");
        this.checkRequired(this.city, "AddressBuilder requires a City");
        this.checkRequired(this.postal, "AddressBuilder requires a Postal Code");
        this.checkRequired(this.street, "AddressBuilder requires a Street");
    }
}

