/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.bbriccs.fhir.coding.SemanticValue;
import de.gematik.bbriccs.fhir.coding.WithChecksum;
import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.coding.exceptions.InvalidSystemException;
import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;

public class KVNR
extends SemanticValue<String, DeBasisProfilNamingSystem>
implements WithChecksum {
    private static final List<DeBasisProfilNamingSystem> KVNR_SYSTEMS = List.of(DeBasisProfilNamingSystem.SID_KVID_GKV, DeBasisProfilNamingSystem.SID_KVID_PKV, DeBasisProfilNamingSystem.KVID);
    private static final Pattern KVNR_PATTERN = Pattern.compile("^([A-Z])(\\d{8})(\\d)$");

    private KVNR(DeBasisProfilNamingSystem namingSystem, String value) {
        super((WithSystem)namingSystem, (Object)value);
    }

    public InsuranceTypeDe getInsuranceType() {
        return switch ((DeBasisProfilNamingSystem)this.getSystem()) {
            case DeBasisProfilNamingSystem.KVID, DeBasisProfilNamingSystem.SID_KVID_GKV -> InsuranceTypeDe.GKV;
            case DeBasisProfilNamingSystem.SID_KVID_PKV -> InsuranceTypeDe.PKV;
            default -> throw new InvalidSystemException(((Object)((Object)this)).getClass(), this.getSystem());
        };
    }

    public boolean isGkv() {
        return ((DeBasisProfilNamingSystem)this.getSystem()).matches(new WithSystem[]{DeBasisProfilNamingSystem.SID_KVID_GKV, DeBasisProfilNamingSystem.KVID});
    }

    public boolean isPkv() {
        return ((DeBasisProfilNamingSystem)this.getSystem()).matches(new WithSystem[]{DeBasisProfilNamingSystem.SID_KVID_PKV});
    }

    public Identifier asIdentifier() {
        return this.asIdentifier(true);
    }

    public Identifier asIdentifier(boolean withCoding) {
        return this.asIdentifier((DeBasisProfilNamingSystem)this.getSystem(), withCoding);
    }

    public Identifier asIdentifier(DeBasisProfilNamingSystem system) {
        return this.asIdentifier(system, true);
    }

    public Identifier asIdentifier(DeBasisProfilNamingSystem system, boolean withCoding) {
        Identifier identifier = super.asIdentifier((WithSystem)system);
        if (withCoding) {
            identifier.getType().addCoding(this.getInsuranceType().asCoding());
        }
        return identifier;
    }

    public boolean isValid() {
        String kvnr = (String)this.getValue();
        if (kvnr == null) {
            return false;
        }
        Matcher matcher = KVNR_PATTERN.matcher(kvnr);
        if (!matcher.matches()) {
            return false;
        }
        int calculated = KVNR.getCalculateCheckNumber(matcher.group(0).charAt(0), matcher.group(2));
        return calculated == this.getChecksum();
    }

    public int getChecksum() {
        String value = (String)this.getValue();
        return Character.getNumericValue(value.charAt(value.length() - 1));
    }

    public static KVNR random() {
        FakerBrick faker = FakerBrick.getGerman();
        if (faker.bool().bool()) {
            return KVNR.randomGkv();
        }
        return KVNR.randomPkv();
    }

    public static KVNR randomPkv() {
        return KVNR.forPkv(KVNR.randomStringValue());
    }

    public static KVNR randomGkv() {
        return KVNR.forGkv(KVNR.randomStringValue());
    }

    public static KVNR forPkv(String value) {
        return KVNR.from(DeBasisProfilNamingSystem.SID_KVID_PKV, value);
    }

    public static KVNR forGkv(String value) {
        return KVNR.from(DeBasisProfilNamingSystem.SID_KVID_GKV, value);
    }

    public static KVNR from(String value) {
        return KVNR.from(DeBasisProfilNamingSystem.KVID, value);
    }

    public static KVNR from(DeBasisProfilNamingSystem namingSystem, String value) {
        return new KVNR(namingSystem, value);
    }

    public static Optional<KVNR> extractFrom(Identifier identifier) {
        return KVNR.extractFrom(List.of(identifier));
    }

    public static Optional<KVNR> extractFrom(List<Identifier> identifiers) {
        return ((EntryStream)StreamEx.of(identifiers).cross(KVNR_SYSTEMS).filter(entry -> ((DeBasisProfilNamingSystem)((Object)((Object)entry.getValue()))).matches(new Identifier[]{(Identifier)entry.getKey()}))).map(entry -> {
            DeBasisProfilNamingSystem system = (DeBasisProfilNamingSystem)((Object)((Object)entry.getValue()));
            String identifierValue = ((Identifier)entry.getKey()).getValue();
            return new KVNR(system, identifierValue);
        }).findFirst();
    }

    public static <P extends Resource> KVNR extractFromOrThrow(Class<P> parent, Identifier identifier) {
        return KVNR.extractFromOrThrow(parent, List.of(identifier));
    }

    public static <P extends Resource> KVNR extractFromOrThrow(Class<P> parent, List<Identifier> identifiers) {
        return KVNR.extractFrom(identifiers).orElseThrow(() -> new MissingFieldException(parent, "KVNR"));
    }

    public static String randomStringValue() {
        FakerBrick faker = FakerBrick.getGerman();
        char capLetter = faker.regexify("[A-Z]{1}").charAt(0);
        String numbers = faker.regexify("[0-9]{8}");
        int checkNum = KVNR.getCalculateCheckNumber(capLetter, numbers);
        return MessageFormat.format("{0}{1}{2}", Character.valueOf(capLetter), numbers, checkNum);
    }

    private static int getCalculateCheckNumber(char capLetter, String numbers) {
        String letterValue = String.format("%02d", capLetter - 64);
        String rawNumber = MessageFormat.format("{0}{1}", letterValue, numbers);
        AtomicInteger idx = new AtomicInteger();
        AtomicInteger sum = new AtomicInteger();
        rawNumber.chars().map(asciiValue -> asciiValue - 48).forEach(value -> {
            if (idx.getAndIncrement() % 2 == 1) {
                value *= 2;
            }
            if (value > 9) {
                value -= 9;
            }
            sum.addAndGet(value);
        });
        return sum.get() % 10;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVNR)) {
            return false;
        }
        KVNR other = (KVNR)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVNR;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

