/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.bbriccs.fhir.coding.SemanticValue;
import de.gematik.bbriccs.fhir.coding.WithChecksum;
import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class IKNR
extends SemanticValue<String, DeBasisProfilNamingSystem>
implements WithChecksum {
    private static final Pattern IKNR_PATTERN = Pattern.compile("^\\d{9}$");

    private IKNR(DeBasisProfilNamingSystem namingSystem, String iknr) {
        super((WithSystem)namingSystem, (Object)iknr);
    }

    public boolean isValid() {
        String iknr = (String)this.getValue();
        if (StringUtils.isBlank((CharSequence)iknr)) {
            return false;
        }
        Matcher matcher = IKNR_PATTERN.matcher(iknr);
        if (!matcher.matches()) {
            return false;
        }
        int calcChecksum = IKNR.calcChecksum(iknr);
        return this.getChecksum() == calcChecksum;
    }

    public int getChecksum() {
        String value = (String)this.getValue();
        return Character.getNumericValue(value.charAt(value.length() - 1));
    }

    public static IKNR asArgeIknr(String value) {
        return new IKNR(DeBasisProfilNamingSystem.ARGE_IKNR, value);
    }

    public static IKNR asSidIknr(String value) {
        return new IKNR(DeBasisProfilNamingSystem.SID_IKNR, value);
    }

    public static IKNR random() {
        FakerBrick faker = FakerBrick.getGerman();
        if (faker.bool().bool()) {
            return IKNR.randomArgeIknr();
        }
        return IKNR.randomSidIknr();
    }

    public static IKNR randomArgeIknr() {
        return IKNR.asArgeIknr(IKNR.randomStringValue());
    }

    public static IKNR randomSidIknr() {
        return IKNR.asSidIknr(IKNR.randomStringValue());
    }

    public static String randomStringValue() {
        FakerBrick faker = FakerBrick.getGerman();
        String numbers = faker.regexify("\\d{8}");
        int checksum = IKNR.calcChecksum(numbers);
        return MessageFormat.format("{0}{1}", numbers, checksum);
    }

    private static int calcChecksum(String number) {
        int sum = 0;
        for (int i = 7; i >= 2; --i) {
            int value = Character.getNumericValue(number.charAt(i));
            if (i % 2 == 0) {
                value *= 2;
            }
            sum += WithChecksum.crossSum((int)value);
        }
        return sum % 10;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IKNR)) {
            return false;
        }
        IKNR other = (IKNR)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IKNR;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

