/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.builder;

import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.DeBasisProfilStructDef;
import de.gematik.bbriccs.fhir.de.HL7StructDef;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class HumanNameBuilder {
    private final HumanName.NameUse use;
    private String family;
    private String given;
    private String prefix;

    public static HumanNameBuilder official() {
        return new HumanNameBuilder(HumanName.NameUse.OFFICIAL);
    }

    public HumanNameBuilder given(String given) {
        this.given = given;
        return this;
    }

    public HumanNameBuilder family(String family) {
        this.family = family;
        return this;
    }

    public HumanNameBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public HumanName buildSimple() {
        HumanName name = new HumanName();
        name.setUse(this.use);
        name.addGiven(this.given).setFamily(this.family);
        if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
            name.addPrefix(this.prefix);
            ((StringType)name.getPrefix().get(0)).addExtension(HL7StructDef.ISO_21090_EN_QUALIFIER.getCanonicalUrl(), (Type)new CodeType("AC"));
        }
        return name;
    }

    public HumanName build() {
        HumanName name = this.buildSimple();
        TokenizedFamilyName tokenized = TokenizedFamilyName.split(this.family);
        name.getFamilyElement().addExtension(HL7StructDef.HUMAN_OWN_NAME.getCanonicalUrl(), (Type)new StringType(tokenized.familyName));
        tokenized.getPrefix().ifPresent(familyPrefix -> name.getFamilyElement().addExtension(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl(), (Type)new StringType(familyPrefix)));
        tokenized.getNameExtension().ifPresent(nameExtension -> name.getFamilyElement().addExtension(DeBasisProfilStructDef.HUMAN_NAMENSZUSATZ.getCanonicalUrl(), (Type)new StringType(nameExtension)));
        return name;
    }

    @Generated
    private HumanNameBuilder(HumanName.NameUse use) {
        this.use = use;
    }

    private record TokenizedFamilyName(@Nullable String nameExtension, @Nullable String prefix, String familyName) {
        private static final List<String> KNOWN_PREFIXES = List.of("von", "zu");

        public Optional<String> getPrefix() {
            return Optional.ofNullable(this.prefix);
        }

        public Optional<String> getNameExtension() {
            return Optional.ofNullable(this.nameExtension);
        }

        public static TokenizedFamilyName split(String family) {
            if (family == null || family.isEmpty() || family.isBlank()) {
                throw new BuilderException("Given family name is missing");
            }
            String[] familyTokens = family.split(" ");
            if (familyTokens.length == 1) {
                return new TokenizedFamilyName(null, null, family);
            }
            if (familyTokens.length == 2) {
                String familyName = familyTokens[1];
                if (KNOWN_PREFIXES.contains(familyTokens[0])) {
                    return new TokenizedFamilyName(null, familyTokens[0], familyName);
                }
                return new TokenizedFamilyName(familyTokens[0], null, familyName);
            }
            String familyName = familyTokens[familyTokens.length - 1];
            String nameExtension = familyTokens[0];
            CharSequence[] prefixTokens = Arrays.copyOfRange(familyTokens, 1, familyTokens.length - 1);
            String prefix = String.join((CharSequence)" ", prefixTokens);
            return new TokenizedFamilyName(nameExtension, prefix, familyName);
        }
    }
}

