/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.de.DeBasisProfilCodeSystem;
import de.gematik.bbriccs.fhir.de.value.PZN;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class PZNTest {
    PZNTest() {
    }

    @ParameterizedTest(name="[{index}]: PZN {0} is valid")
    @ValueSource(strings={"27580899", "20987327", "91168337"})
    void shouldValidPZN(String value) {
        PZN pzn = PZN.from((String)value);
        Assertions.assertTrue((boolean)pzn.isValid());
    }

    @RepeatedTest(value=5)
    void shouldGenerateRandomValidPZN() {
        PZN pzn = PZN.random();
        Assertions.assertTrue((boolean)pzn.isValid());
    }

    @ParameterizedTest(name="[{index}]: PZN {0} is invalid")
    @ValueSource(strings={"abc", "1234", "123456789", "91168338"})
    @NullSource
    void shouldCheckInvalidPznCheckDigit(String value) {
        PZN pzn = PZN.from((String)value);
        Assertions.assertFalse((boolean)pzn.isValid());
    }

    @ParameterizedTest(name="[{index}]: PZN {0} is invalid with CheckSum 10")
    @ValueSource(strings={"06659310", "53089840", "30650630"})
    @NullSource
    void shouldCheckInvalidPznCheckDigitTen(String value) {
        PZN pzn = PZN.from((String)value);
        Assertions.assertFalse((boolean)pzn.isValid());
    }

    @Test
    void shouldBuildAsNamedCodeable() {
        PZN pzn = PZN.from((String)"27580899");
        CodeableConcept codeable = pzn.asNamedCodeable();
        Assertions.assertNotNull((Object)codeable.getText());
        Coding coding = codeable.getCodingFirstRep();
        Assertions.assertEquals((Object)"27580899", (Object)coding.getCode());
    }

    @Test
    void shouldGeneratePznFromCoding() {
        Coding coding = DeBasisProfilCodeSystem.PZN.asCoding("27580899");
        PZN pzn = PZN.from((Coding)coding);
        Assertions.assertEquals((Object)"27580899", (Object)pzn.getValue());
    }
}

