/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidSystemException;
import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EmptySource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class KVNRTest {
    KVNRTest() {
    }

    @ParameterizedTest(name="[{index}]: KVNR {0} is structurally invalid")
    @NullSource
    @EmptySource
    @ValueSource(strings={"k220645129", "\u00f6220645129", "\u00c4220645129", "1220645129", "A2206451290", "B22064512", "123"})
    void shouldCheckInvalidKvnrFormat(String value) {
        KVNR kvnr = KVNR.from((String)value);
        Assertions.assertFalse((boolean)kvnr.isValid());
    }

    @ParameterizedTest(name="[{index}]: KVNR {0} has a invalid check number")
    @ValueSource(strings={"K220645129", "T012345679", "A005000112", "C000500020"})
    void shouldCheckInvalidKvnrCheckDigit(String value) {
        KVNR kvnr = KVNR.from((String)value);
        Assertions.assertFalse((boolean)kvnr.isValid());
    }

    @ParameterizedTest(name="[{index}]: KVNR {0} is valid")
    @ValueSource(strings={"A000500015", "K220645122", "T012345678", "A000500015", "C000500021"})
    void shouldCheckValidKvnr(String value) {
        KVNR kvnr = KVNR.from((String)value);
        Assertions.assertTrue((boolean)kvnr.isValid());
    }

    @RepeatedTest(value=5)
    void shouldGenerateRandomValidKvid() {
        KVNR kvnr = KVNR.random();
        Assertions.assertTrue((boolean)kvnr.isValid());
    }

    @Test
    void shouldGenerateRandomPkv() {
        KVNR kvnr = KVNR.randomPkv();
        Assertions.assertTrue((boolean)kvnr.isValid());
        Assertions.assertEquals((Object)DeBasisProfilNamingSystem.SID_KVID_PKV.getCanonicalUrl(), (Object)kvnr.getSystemUrl());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kvnr.getInsuranceType());
        Assertions.assertTrue((boolean)kvnr.isPkv());
    }

    @Test
    void shouldGenerateRandomGkv() {
        KVNR kvnr = KVNR.randomGkv();
        Assertions.assertTrue((boolean)kvnr.isValid());
        Assertions.assertEquals((Object)DeBasisProfilNamingSystem.SID_KVID_GKV.getCanonicalUrl(), (Object)kvnr.getSystemUrl());
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)kvnr.getInsuranceType());
        Assertions.assertTrue((boolean)kvnr.isGkv());
    }

    @Test
    void shouldCreateAsIdentifier() {
        KVNR kvnr = KVNR.randomGkv();
        Identifier identifier = kvnr.asIdentifier();
        Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.SID_KVID_GKV.matches(new Identifier[]{identifier}));
        String code = identifier.getType().getCodingFirstRep().getCode();
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV.getCode(), (Object)code);
    }

    @Test
    void shouldCreateAsIdentifierWithoutDisplay() {
        KVNR kvnr = KVNR.randomGkv();
        Identifier identifier = kvnr.asIdentifier(false);
        Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.SID_KVID_GKV.matches(new Identifier[]{identifier}));
        String code = identifier.getType().getCodingFirstRep().getCode();
        Assertions.assertNull((Object)code);
    }

    @Test
    void shouldCreateAsIdentifierWithCustomSystem() {
        KVNR kvnr = KVNR.randomGkv();
        Identifier identifier = kvnr.asIdentifier(DeBasisProfilNamingSystem.KVID);
        Assertions.assertFalse((boolean)DeBasisProfilNamingSystem.SID_KVID_GKV.matches(new Identifier[]{identifier}));
        String code = identifier.getType().getCodingFirstRep().getCode();
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV.getCode(), (Object)code);
    }

    @Test
    void shouldThrowOnInvalidSystem() {
        KVNR kvnr = (KVNR)Mockito.spy((Object)KVNR.randomGkv());
        Mockito.when((Object)((DeBasisProfilNamingSystem)kvnr.getSystem())).thenReturn((Object)DeBasisProfilNamingSystem.ARGE_IKNR);
        Assertions.assertThrows(InvalidSystemException.class, () -> ((KVNR)kvnr).getInsuranceType());
    }

    @RepeatedTest(value=10)
    void shouldExtractFromIdentifier() {
        KVNR originalKvnr = KVNR.random();
        Identifier identifier = originalKvnr.asIdentifier();
        Optional kvnr = KVNR.extractFrom((Identifier)identifier);
        Assertions.assertTrue((boolean)kvnr.isPresent());
        Assertions.assertEquals((Object)originalKvnr, kvnr.get());
    }

    @RepeatedTest(value=10)
    void shouldExtractFromIdentifiers() {
        KVNR originalKvnr = KVNR.random();
        Identifier kvnrIdentifier = originalKvnr.asIdentifier();
        Identifier iknrIdentifier = IKNR.random().asIdentifier();
        Identifier pznIdentifier = PZN.random().asIdentifier();
        Optional kvnr = KVNR.extractFrom(List.of(pznIdentifier, iknrIdentifier, kvnrIdentifier));
        Assertions.assertTrue((boolean)kvnr.isPresent());
        Assertions.assertEquals((Object)originalKvnr, kvnr.get());
    }

    @RepeatedTest(value=10)
    void shouldThrowOnMissingKvnrInIdentifiers() {
        Identifier iknrIdentifier = IKNR.random().asIdentifier();
        Identifier pznIdentifier = PZN.random().asIdentifier();
        List<Identifier> identifiers = List.of(pznIdentifier, iknrIdentifier);
        Assertions.assertThrows(MissingFieldException.class, () -> KVNR.extractFromOrThrow(Task.class, (List)identifiers));
    }

    @RepeatedTest(value=10)
    void shouldThrowOnInvalidIdentifier() {
        Identifier iknrIdentifier = IKNR.random().asIdentifier();
        Assertions.assertThrows(MissingFieldException.class, () -> KVNR.extractFromOrThrow(Task.class, (Identifier)iknrIdentifier));
    }

    @RepeatedTest(value=10)
    void shouldNotThrowOnValidIdentifier() {
        Identifier identifier = KVNR.random().asIdentifier();
        Assertions.assertDoesNotThrow(() -> KVNR.extractFromOrThrow(Task.class, (Identifier)identifier));
    }
}

