/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.de.value.IKNR;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class IKNRTest {
    IKNRTest() {
    }

    @ParameterizedTest(name="[{index}]: IKNR {0} is valid")
    @ValueSource(strings={"260326822"})
    void shouldValidateIKNR(String value) {
        IKNR sidIknr = IKNR.asSidIknr((String)value);
        IKNR argeIknr = IKNR.asArgeIknr((String)value);
        Assertions.assertTrue((boolean)sidIknr.isValid());
        Assertions.assertTrue((boolean)argeIknr.isValid());
    }

    @RepeatedTest(value=5)
    void shouldGenerateRandomValidIKNR() {
        IKNR iknr = IKNR.random();
        Assertions.assertTrue((boolean)iknr.isValid());
    }

    @Test
    void shouldNotEqualOnDifferentSystems() {
        IKNR first = IKNR.asArgeIknr((String)"413799875");
        IKNR second = IKNR.asSidIknr((String)"413799875");
        Assertions.assertNotEquals((Object)first, (Object)second);
    }

    @ParameterizedTest(name="[{index}]: IKNR {0} is invalid")
    @ValueSource(strings={"413799876", "abc", "12345678", "1234567890", "", " "})
    @NullSource
    void shouldCheckInvalidIKNRCheckDigit(String value) {
        IKNR argeIknr = IKNR.asArgeIknr((String)value);
        IKNR sidIknr = IKNR.asSidIknr((String)value);
        Assertions.assertFalse((boolean)argeIknr.isValid());
        Assertions.assertFalse((boolean)sidIknr.isValid());
    }
}

