/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilCodeSystem;
import de.gematik.bbriccs.fhir.de.value.ATC;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ATCTest {
    ATCTest() {
    }

    @Test
    void shouldBuildFromCoding() {
        ATC atc = ATC.from((Coding)new Coding("http://fhir.de/CodeSystem/bfarm/atc", "M01AE01", "Ibuprofen"));
        Assertions.assertEquals((Object)DeBasisProfilCodeSystem.ATC, (Object)atc.getSystem());
        Assertions.assertTrue((boolean)atc.getDisplay().isPresent());
        Assertions.assertTrue((boolean)atc.getVersion().isEmpty());
    }

    @Test
    void shouldBuildFromCodeWithDisplayAndVersion() {
        ATC atc = ATC.from((String)"M01AE01", (String)"Ibuprofen", (String)"2022");
        Assertions.assertTrue((boolean)((DeBasisProfilCodeSystem)atc.getSystem()).matches(new WithSystem[]{DeBasisProfilCodeSystem.ATC}));
        Assertions.assertEquals((Object)"Ibuprofen", atc.getDisplay().orElseThrow());
        Assertions.assertEquals((Object)"2022", atc.getVersion().orElseThrow());
    }

    @Test
    void shouldBuildFromCodeSimple() {
        ATC atc = ATC.from((String)"M01AE01");
        Assertions.assertTrue((boolean)((DeBasisProfilCodeSystem)atc.getSystem()).matches(new WithSystem[]{DeBasisProfilCodeSystem.ATC}));
        Assertions.assertTrue((boolean)atc.getVersion().isEmpty());
        Assertions.assertTrue((boolean)atc.getDisplay().isEmpty());
    }
}

