/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.value;

import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilCodeSystem;
import de.gematik.bbriccs.fhir.de.value.ASK;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ASKTest {
    ASKTest() {
    }

    @Test
    void getDisplayShouldWork() {
        String disp = "Ibuprofen";
        ASK ask = ASK.from((Coding)new Coding("http://fhir.de/CodeSystem/ask", "5682", "Ibuprofen"));
        Assertions.assertTrue((boolean)ask.getDisplay().isPresent());
        Assertions.assertEquals((Object)"Ibuprofen", ask.getDisplay().orElseThrow());
    }

    @Test
    void shouldResponseAskWithFrom() {
        ASK ask = ASK.from((Coding)new Coding("http://fhir.de/CodeSystem/ask", "5682", "Ibuprofen"));
        Assertions.assertTrue((boolean)ask.getDisplay().isPresent());
        Assertions.assertEquals((Object)DeBasisProfilCodeSystem.ASK, (Object)ask.getSystem());
        Assertions.assertTrue((boolean)ask.getDisplay().isPresent());
    }

    @Test
    void shouldResponseAskWithFormCode() {
        ASK ask = ASK.from((String)"5682");
        Assertions.assertTrue((boolean)((DeBasisProfilCodeSystem)ask.getSystem()).matches(new WithSystem[]{DeBasisProfilCodeSystem.ASK}));
        Assertions.assertTrue((boolean)ask.getDisplay().isEmpty());
        Assertions.assertEquals((Object)"5682", (Object)ask.getValue());
    }
}

