/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de.builder;

import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.DeBasisProfilStructDef;
import de.gematik.bbriccs.fhir.de.HL7StructDef;
import de.gematik.bbriccs.fhir.de.builder.HumanNameBuilder;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class HumanNameBuilderTest {
    HumanNameBuilderTest() {
    }

    @Test
    void shouldBuildOldHumanName() {
        HumanName hn = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("M\u00fcller").buildSimple();
        Assertions.assertEquals((Object)"Dr. med.", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"M\u00fcller", (Object)hn.getFamily());
    }

    @Test
    void shouldBuildHumanNameWithoutPrefix01() {
        HumanName hn = HumanNameBuilder.official().given("Paul").family("M\u00fcller").buildSimple();
        Assertions.assertEquals((Object)"", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"M\u00fcller", (Object)hn.getFamily());
    }

    @ParameterizedTest(name="[{index}] Build Human Name with empty prefix ''{0}''")
    @ValueSource(strings={"", " ", "\t", "\n"})
    @NullSource
    void shouldBuildHumanNameWithoutPrefix02(String prefix) {
        HumanName hn = HumanNameBuilder.official().prefix(prefix).given("Paul").family("M\u00fcller").build();
        Assertions.assertEquals((Object)"", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((int)0, (int)hn.getPrefix().size());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"M\u00fcller", (Object)hn.getFamily());
    }

    @Test
    void shouldBuildNewHumanName() {
        HumanName hn = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("Freiherr von M\u00fcller").build();
        Assertions.assertEquals((Object)"Dr. med.", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"Freiherr von M\u00fcller", (Object)hn.getFamily());
        Extension prefixExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl());
        Assertions.assertNotNull((Object)prefixExtension);
        Assertions.assertEquals((Object)"von", (Object)prefixExtension.getValue().primitiveValue());
        Extension ownNameExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_NAME.getCanonicalUrl());
        Assertions.assertNotNull((Object)ownNameExtension);
        Assertions.assertEquals((Object)"M\u00fcller", (Object)ownNameExtension.getValue().primitiveValue());
        Extension nameZusatzExtension = hn.getFamilyElement().getExtensionByUrl(DeBasisProfilStructDef.HUMAN_NAMENSZUSATZ.getCanonicalUrl());
        Assertions.assertNotNull((Object)nameZusatzExtension);
        Assertions.assertEquals((Object)"Freiherr", (Object)nameZusatzExtension.getValue().primitiveValue());
    }

    @Test
    void shouldBuildWithKnownNobilityPrefix() {
        HumanName hn = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("zu M\u00fcller").build();
        Assertions.assertEquals((Object)"Dr. med.", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"zu M\u00fcller", (Object)hn.getFamily());
        Extension prefixExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl());
        Assertions.assertNotNull((Object)prefixExtension);
        Assertions.assertEquals((Object)"zu", (Object)prefixExtension.getValue().primitiveValue());
    }

    @Test
    void shouldBuildWithUnknownNobilityPrefix() {
        HumanName hn = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("zum M\u00fcller").build();
        Assertions.assertEquals((Object)"Dr. med.", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"zum M\u00fcller", (Object)hn.getFamily());
        Extension prefixExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl());
        Assertions.assertNull((Object)prefixExtension);
    }

    @Test
    void shouldBuildNewHumanNameWithoutNobility() {
        HumanName hn = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("von M\u00fcller").build();
        Assertions.assertEquals((Object)"Dr. med.", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Paul", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"von M\u00fcller", (Object)hn.getFamily());
        Extension prefixExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl());
        Assertions.assertNotNull((Object)prefixExtension);
        Assertions.assertEquals((Object)"von", (Object)prefixExtension.getValue().primitiveValue());
        Extension ownNameExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_NAME.getCanonicalUrl());
        Assertions.assertNotNull((Object)ownNameExtension);
        Assertions.assertEquals((Object)"M\u00fcller", (Object)ownNameExtension.getValue().primitiveValue());
        Extension nameZusatzExtension = hn.getFamilyElement().getExtensionByUrl(DeBasisProfilStructDef.HUMAN_NAMENSZUSATZ.getCanonicalUrl());
        Assertions.assertNull((Object)nameZusatzExtension);
    }

    @Test
    void shouldBuildNewComplexHumanName() {
        HumanName hn = HumanNameBuilder.official().prefix("Prof. habil. Dr. med").given("Friedrich-Wilhelm-Karl-Gustav-Justus-Gotfried").family("Grossherzog von und zu der Schaumberg-von-und-zu-Schaumburg-und-Radeberg").build();
        Assertions.assertEquals((Object)"Prof. habil. Dr. med", (Object)hn.getPrefixAsSingleString());
        Assertions.assertEquals((Object)"Friedrich-Wilhelm-Karl-Gustav-Justus-Gotfried", (Object)hn.getGivenAsSingleString());
        Assertions.assertEquals((Object)"Grossherzog von und zu der Schaumberg-von-und-zu-Schaumburg-und-Radeberg", (Object)hn.getFamily());
        Extension prefixExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_PREFIX.getCanonicalUrl());
        Assertions.assertNotNull((Object)prefixExtension);
        Assertions.assertEquals((Object)"von und zu der", (Object)prefixExtension.getValue().primitiveValue());
        Extension ownNameExtension = hn.getFamilyElement().getExtensionByUrl(HL7StructDef.HUMAN_OWN_NAME.getCanonicalUrl());
        Assertions.assertNotNull((Object)ownNameExtension);
        Assertions.assertEquals((Object)"Schaumberg-von-und-zu-Schaumburg-und-Radeberg", (Object)ownNameExtension.getValue().primitiveValue());
        Extension nameZusatzExtension = hn.getFamilyElement().getExtensionByUrl(DeBasisProfilStructDef.HUMAN_NAMENSZUSATZ.getCanonicalUrl());
        Assertions.assertNotNull((Object)nameZusatzExtension);
        Assertions.assertEquals((Object)"Grossherzog", (Object)nameZusatzExtension.getValue().primitiveValue());
    }

    @Test
    void shouldThrowOnEmptyFamilyName() {
        HumanNameBuilder hnb = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("");
        Assertions.assertThrows(BuilderException.class, () -> ((HumanNameBuilder)hnb).build());
    }

    @Test
    void shouldThrowOnBlankFamilyName() {
        HumanNameBuilder hnb = HumanNameBuilder.official().prefix("Dr. med.").given("Paul").family("  ");
        Assertions.assertThrows(BuilderException.class, () -> ((HumanNameBuilder)hnb).build());
    }

    @Test
    void shouldThrowOnMissingFamilyName() {
        HumanNameBuilder hnb = HumanNameBuilder.official().prefix("Dr. med.").given("Paul");
        Assertions.assertThrows(BuilderException.class, () -> ((HumanNameBuilder)hnb).build());
    }
}

