/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.de;

import de.gematik.bbriccs.fhir.conf.ProfilesConfigurator;
import de.gematik.bbriccs.fhir.de.DeBasisProfilVersion;
import de.gematik.bbriccs.utils.SingletonUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

class DeBasisProfilVersionTest {
    DeBasisProfilVersionTest() {
    }

    @BeforeEach
    void clearProfileSingleton() {
        SingletonUtil.resetSingleton(ProfilesConfigurator.class);
    }

    @Test
    void shouldGetDefault() {
        DeBasisProfilVersion dv = DeBasisProfilVersion.getDefaultVersion();
        Assertions.assertEquals((Object)DeBasisProfilVersion.V1_4_0, (Object)dv);
    }

    @Test
    void shouldGetVersionFromString() {
        DeBasisProfilVersion dv = DeBasisProfilVersion.fromString((String)"0.9.13");
        Assertions.assertEquals((Object)DeBasisProfilVersion.V0_9_13, (Object)dv);
    }

    @Test
    @SetSystemProperty(key="bbriccs.fhir.profile", value="1.3.2")
    void shouldGetDefaultVersionFromSysProp() {
        DeBasisProfilVersion dv = DeBasisProfilVersion.getDefaultVersion();
        Assertions.assertEquals((Object)DeBasisProfilVersion.V1_3_2, (Object)dv);
    }
}

