/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.conf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.bbriccs.fhir.conf.ProfileDto;
import de.gematik.bbriccs.fhir.conf.ProfileSettingsDto;
import de.gematik.bbriccs.fhir.conf.exceptions.FhirConfigurationException;
import de.gematik.bbriccs.toggle.FeatureToggle;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilesConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfilesConfigurator.class);
    private static final String DEFAULT_SYS_PROP_TOGGLE = "bbriccs.fhir.profile";
    private static final String DEFAULT_RND_SYS_PROP_TOGGLE = String.valueOf(System.currentTimeMillis());
    private static final String DEFAULT_CONFIG_FILE_NAME = "fhir/configuration.yaml";
    private static final Map<String, ProfilesConfigurator> configCache = new HashMap<String, ProfilesConfigurator>();
    private final List<ProfileSettingsDto> profileConfigurations;
    private final String featureToggleName;
    private ProfileSettingsDto defaultProfile;

    private ProfilesConfigurator(List<ProfileSettingsDto> profileConfigurations, String featureToggleName) {
        this.profileConfigurations = profileConfigurations;
        this.featureToggleName = featureToggleName;
        this.defaultProfile = this.initializeDefaultProfile();
    }

    private ProfileSettingsDto initializeDefaultProfile() {
        Optional externalConfiguration = FeatureToggle.getStringToggle((String)this.featureToggleName);
        return externalConfiguration.map(cfg -> this.profileConfigurations.stream().filter(config -> config.getId().equalsIgnoreCase((String)cfg)).findFirst().orElseThrow(() -> new FhirConfigurationException(MessageFormat.format("Configured Profile Setting {0} is not found within {1}", cfg, this.profileConfigurations.stream().map(ProfileSettingsDto::getId).collect(Collectors.joining(", ")))))).orElse(this.profileConfigurations.get(0));
    }

    public ProfileSettingsDto getDefaultProfile() {
        Optional externalConfiguration = FeatureToggle.getStringToggle((String)this.featureToggleName);
        externalConfiguration.filter(cfg -> !cfg.equalsIgnoreCase(this.defaultProfile.getId())).ifPresent(cfg -> {
            this.defaultProfile = this.initializeDefaultProfile();
        });
        return this.defaultProfile;
    }

    public static ProfilesConfigurator getConfiguration(String name) {
        return ProfilesConfigurator.getConfiguration(name, DEFAULT_RND_SYS_PROP_TOGGLE);
    }

    public static ProfilesConfigurator getConfiguration(String name, String featureToggleName) {
        String cfgFile = Optional.of(name).map(rawName -> rawName.startsWith("fhir/") ? rawName : MessageFormat.format("fhir/{0}", rawName)).map(rawName -> FilenameUtils.isExtension((String)rawName, (String[])new String[]{"yaml", "yml"}) ? rawName : MessageFormat.format("{0}.yaml", rawName)).orElseThrow();
        String configuratorKey = MessageFormat.format("{0}-{1}", cfgFile, featureToggleName);
        return configCache.computeIfAbsent(configuratorKey, key -> ProfilesConfigurator.createConfigurator(cfgFile, featureToggleName));
    }

    public static ProfilesConfigurator getDefaultConfiguration(String featureToggleName) {
        return ProfilesConfigurator.getConfiguration(DEFAULT_CONFIG_FILE_NAME, featureToggleName);
    }

    public static ProfilesConfigurator getDefaultConfiguration() {
        return ProfilesConfigurator.getConfiguration(DEFAULT_CONFIG_FILE_NAME, DEFAULT_SYS_PROP_TOGGLE);
    }

    public static Optional<ProfileDto> getVirtualDefaultProfile(String profileName) {
        return configCache.entrySet().stream().flatMap(entry -> ((ProfilesConfigurator)entry.getValue()).getDefaultProfile().getProfiles().stream()).filter(profile -> profile.getName().equalsIgnoreCase(profileName)).findFirst();
    }

    private static ProfilesConfigurator createConfigurator(String cfgFile, String featureToggleName) {
        String profilesConfig = ResourceLoader.readFileFromResource((String)cfgFile);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
        return new ProfilesConfigurator(configuredProfiles, featureToggleName);
    }

    @Generated
    public List<ProfileSettingsDto> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    @Generated
    public String getFeatureToggleName() {
        return this.featureToggleName;
    }
}

