/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.conf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.bbriccs.fhir.conf.ProfileSettingsDto;
import de.gematik.bbriccs.fhir.conf.exceptions.InvalidConfigurationException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ProfilesConfigurator {
    private static final String ENV_TOGGLE = "BBRICCS_FHIR_PROFILE";
    private static final String SYS_PROP_TOGGLE = "bbriccs.fhir.profile";
    private static final String CONFIG_FILE_NAME = "fhir/configuration.yaml";
    private static ProfilesConfigurator instance;
    private final List<ProfileSettingsDto> profileConfigurations;
    private final ProfileSettingsDto defaultProfile;

    private ProfilesConfigurator(List<ProfileSettingsDto> profileConfigurations, ProfileSettingsDto defaultProfile) {
        this.profileConfigurations = profileConfigurations;
        this.defaultProfile = defaultProfile;
    }

    public static ProfilesConfigurator getInstance() {
        if (instance == null) {
            String profilesConfig = ResourceLoader.readFileFromResource((String)CONFIG_FILE_NAME);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
            String externalConfiguration = System.getProperty(SYS_PROP_TOGGLE, System.getenv(ENV_TOGGLE));
            ProfileSettingsDto defaultConfig = externalConfiguration != null ? configuredProfiles.stream().filter(config -> config.getId().equalsIgnoreCase(externalConfiguration)).findFirst().orElseThrow(() -> new InvalidConfigurationException(MessageFormat.format("Configured Profile Setting {0} is not found within {1}", externalConfiguration, configuredProfiles.stream().map(ProfileSettingsDto::getId).collect(Collectors.joining(", "))))) : (ProfileSettingsDto)configuredProfiles.get(0);
            instance = new ProfilesConfigurator(configuredProfiles, defaultConfig);
        }
        return instance;
    }

    @Generated
    public List<ProfileSettingsDto> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    @Generated
    public ProfileSettingsDto getDefaultProfile() {
        return this.defaultProfile;
    }
}

