/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.bbriccs.fhir.coding.WithStructureDefinition;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;

public class ResourceTypeHint<T extends ProfileVersion, R extends Resource> {
    private final WithStructureDefinition<T> definition;
    private final List<T> versions;
    private final Class<R> mappingClass;

    private ResourceTypeHint(WithStructureDefinition<T> definition, Class<R> mappingClass, List<T> versions) {
        this.definition = definition;
        this.versions = versions;
        this.mappingClass = mappingClass;
    }

    public void register(FhirContext ctx) {
        ctx.setDefaultTypeForProfile(this.definition.getCanonicalUrl(), this.mappingClass);
        this.versions.forEach(v -> ctx.setDefaultTypeForProfile(this.definition.getVersionedUrl(v), this.mappingClass));
    }

    public static <T extends ProfileVersion> Builder<T> forStructure(WithStructureDefinition<T> definition) {
        return new Builder<T>(definition);
    }

    public static class Builder<T extends ProfileVersion> {
        private final WithStructureDefinition<T> definition;
        private final List<T> versions = new LinkedList<T>();

        @SafeVarargs
        public final Builder<T> forVersion(T ... versions) {
            this.versions.addAll(Arrays.asList(versions));
            return this;
        }

        public Builder<T> forAllVersionsFrom(Class<T> versionClass) {
            if (!versionClass.isEnum()) {
                throw new IllegalArgumentException("Register ResourceTypeHint for all versions must be an enum");
            }
            return this.forVersion((ProfileVersion[])versionClass.getEnumConstants());
        }

        public <R extends Resource> ResourceTypeHint<T, R> mappingTo(Class<R> mappingClass) {
            return new ResourceTypeHint<T, R>(this.definition, mappingClass, this.versions);
        }

        @Generated
        private Builder(WithStructureDefinition<T> definition) {
            this.definition = definition;
        }
    }
}

