/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import java.text.MessageFormat;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.OperationOutcome;

public class OperationOutcomeExtractor {
    private final OperationOutcome operationOutcome;

    private OperationOutcomeExtractor(OperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    public static OperationOutcomeExtractor from(OperationOutcome operationOutcome) {
        return new OperationOutcomeExtractor(operationOutcome);
    }

    public static String extractFrom(OperationOutcome operationOutcome) {
        return new OperationOutcomeExtractor(operationOutcome).toString();
    }

    public String toString() {
        return this.operationOutcome.getIssue().stream().map(issue -> {
            Object message = MessageFormat.format("[{0}] {1}", issue.getSeverity(), issue.getDetails().getText());
            if (issue.hasDiagnostics()) {
                message = (String)message + MessageFormat.format(": {0}", issue.getDiagnostics());
            }
            return message;
        }).collect(Collectors.joining("\n"));
    }
}

