/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.ResourceTypeHint;
import de.gematik.bbriccs.fhir.codec.exceptions.FhirCodecException;
import de.gematik.bbriccs.fhir.coding.WithStructureDefinition;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import de.gematik.bbriccs.fhir.validation.DummyValidator;
import de.gematik.bbriccs.fhir.validation.NonProfiledValidator;
import de.gematik.bbriccs.fhir.validation.ReferenzValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.refv.SupportedValidationModule;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;

public class FhirCodec {
    private final FhirContext ctx;
    private IParser xmlParser;
    private IParser jsonParser;
    private final ValidatorFhir validator;

    protected FhirCodec(FhirContext ctx, ValidatorFhir validator) {
        this.ctx = ctx;
        this.validator = validator;
    }

    public String encode(IBaseResource resource, EncodingType encoding) {
        return this.encode(resource, encoding, false);
    }

    public String encode(IBaseResource resource, EncodingType encoding, boolean prettyPrint) {
        if (resource instanceof EmptyResource) {
            return "";
        }
        IParser parser = encoding.chooseAppropriateParser(this::getXmlParser, this::getJsonParser);
        parser.setPrettyPrint(prettyPrint);
        return parser.encodeResourceToString(resource);
    }

    public <T extends Resource> T decode(Class<T> expectedClass, String content) {
        EncodingType encoding = EncodingType.guessFromContent((String)content);
        return this.decode(expectedClass, content, encoding);
    }

    public synchronized <T extends Resource> T decode(Class<T> expectedClass, String content, EncodingType encoding) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return (T)((Object)new EmptyResource());
        }
        IParser parser = encoding.chooseAppropriateParser(this::getXmlParser, this::getJsonParser);
        try {
            return (T)((Resource)parser.parseResource(expectedClass, content));
        }
        catch (Throwable t) {
            throw new FhirCodecException(MessageFormat.format("Error while decoding content of length {0} as {1}", content.length(), expectedClass), t);
        }
    }

    public Resource decode(String content) {
        EncodingType encoding = EncodingType.guessFromContent((String)content);
        return this.decode(content, encoding);
    }

    public Resource decode(String content, EncodingType encoding) {
        return this.decode(null, content, encoding);
    }

    private IParser getXmlParser() {
        if (this.xmlParser == null) {
            this.xmlParser = this.ctx.newXmlParser();
        }
        return this.xmlParser;
    }

    private IParser getJsonParser() {
        if (this.jsonParser == null) {
            this.jsonParser = this.ctx.newJsonParser();
        }
        return this.jsonParser;
    }

    public static FhirCodecBuilder forR4() {
        return new FhirCodecBuilder(FhirContext.forR4());
    }

    @Generated
    public FhirContext getContext() {
        return this.validator.getContext();
    }

    @Generated
    public ValidationResult validate(String arg0) {
        return this.validator.validate(arg0);
    }

    @Generated
    public ValidationResult validate(IBaseResource resource) {
        return this.validator.validate(resource);
    }

    @Generated
    public boolean isValid(String content) {
        return this.validator.isValid(content);
    }

    @Generated
    public boolean isValid(IBaseResource resource) {
        return this.validator.isValid(resource);
    }

    public static class FhirCodecBuilder {
        private final FhirContext ctx;
        private final List<ResourceTypeHint<?, ?>> typeHints;

        private FhirCodecBuilder(FhirContext ctx) {
            this.ctx = ctx;
            this.typeHints = new LinkedList();
        }

        public FhirCodecBuilder disableErrors() {
            LenientErrorHandler errorHandler = new LenientErrorHandler();
            errorHandler.disableAllErrors();
            this.ctx.setParserErrorHandler((IParserErrorHandler)errorHandler);
            return this;
        }

        public <T extends ProfileVersion, R extends Resource> FhirCodecBuilder withTypeHint(WithStructureDefinition<T> definition, Class<R> mappingClass) {
            return this.withTypeHint(ResourceTypeHint.forStructure(definition).mappingTo(mappingClass));
        }

        public <T extends ProfileVersion, R extends Resource> FhirCodecBuilder withTypeHint(WithStructureDefinition<T> definition, @Nullable T version, Class<R> mappingClass) {
            return this.withTypeHint(ResourceTypeHint.forStructure(definition).forVersion(new ProfileVersion[]{version}).mappingTo(mappingClass));
        }

        public <T extends ProfileVersion, R extends Resource> FhirCodecBuilder withTypeHint(ResourceTypeHint<T, R> typeHint) {
            this.typeHints.add(typeHint);
            return this;
        }

        public <T extends ResourceTypeHint<? extends ProfileVersion, ? extends Resource>> FhirCodecBuilder withTypeHints(List<T> typeHints) {
            this.typeHints.addAll(typeHints);
            return this;
        }

        public FhirCodec andNonProfiledValidator() {
            NonProfiledValidator validator = new NonProfiledValidator(this.ctx);
            return this.andCustomValidator((ValidatorFhir)validator);
        }

        public FhirCodec andDummyValidator() {
            DummyValidator validator = new DummyValidator(this.ctx);
            return this.andCustomValidator((ValidatorFhir)validator);
        }

        public FhirCodec andBbriccsValidator() {
            ValidatorFhir validator = ValidatorFhirFactory.createValidator((FhirContext)this.ctx);
            return this.andCustomValidator(validator);
        }

        public FhirCodec andReferenzValidator(SupportedValidationModule svm) {
            ValidatorFhir validator = ReferenzValidator.withValidationModule((FhirContext)this.ctx, (SupportedValidationModule)svm);
            return this.andCustomValidator(validator);
        }

        public FhirCodec andCustomValidator(ValidatorFhir validator) {
            this.typeHints.forEach(th -> th.register(this.ctx));
            return new FhirCodec(this.ctx, validator);
        }
    }
}

