/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import de.gematik.bbriccs.fhir.codec.OperationOutcomeExtractor;
import de.gematik.bbriccs.fhir.codec.utils.FhirTestResourceUtil;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OperationOutcomeExtractorTest {
    OperationOutcomeExtractorTest() {
    }

    @Test
    void shouldExtractErrorDetails() {
        OperationOutcome oo = FhirTestResourceUtil.createOperationOutcome();
        OperationOutcomeExtractor wrapper = OperationOutcomeExtractor.from((OperationOutcome)oo);
        Assertions.assertDoesNotThrow(() -> ((OperationOutcomeExtractor)wrapper).toString());
    }

    @Test
    void shouldExtractErrorDetailsWithoutDiagnostics() {
        OperationOutcome oo = FhirTestResourceUtil.createOperationOutcome();
        oo.getIssueFirstRep().setDiagnostics(null);
        OperationOutcomeExtractor wrapper = OperationOutcomeExtractor.from((OperationOutcome)oo);
        Assertions.assertDoesNotThrow(() -> ((OperationOutcomeExtractor)wrapper).toString());
    }

    @Test
    void shouldExtractDirectly() {
        OperationOutcome oo = FhirTestResourceUtil.createOperationOutcome();
        Assertions.assertDoesNotThrow(() -> OperationOutcomeExtractor.extractFrom((OperationOutcome)oo));
    }
}

