/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec.utils;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.mockito.Mockito;

public class FhirTestResourceUtil {
    private FhirTestResourceUtil() {
        throw new AssertionError();
    }

    public static OperationOutcome createOperationOutcome() {
        OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent();
        issue.setCode(OperationOutcome.IssueType.VALUE);
        issue.setSeverity(OperationOutcome.IssueSeverity.ERROR);
        issue.getDetails().setText("error details");
        issue.setDiagnostics("additional diagnostics about the error");
        OperationOutcome oo = new OperationOutcome();
        LinkedList<OperationOutcome.OperationOutcomeIssueComponent> issueList = new LinkedList<OperationOutcome.OperationOutcomeIssueComponent>();
        issueList.add(issue);
        oo.setIssue(issueList);
        oo.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        oo.getText().setDivAsString("<div>narrative</div>");
        oo.setId((IIdType)IdType.newRandomUuid());
        return oo;
    }

    public static ValidationResult createEmptyValidationResult() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)vr.getMessages()).thenReturn(List.of());
        return vr;
    }

    public static ValidationResult createFailingValidationResult() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)false);
        SingleValidationMessage errorMessage = new SingleValidationMessage();
        errorMessage.setMessage("mock error message");
        errorMessage.setSeverity(ResultSeverityEnum.ERROR);
        Mockito.when((Object)vr.getMessages()).thenReturn(List.of(errorMessage));
        return vr;
    }

    public static ValidationResult createFailingValidationResultWithAllSeverities() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)false);
        List<SingleValidationMessage> errorMessages = Arrays.stream(ResultSeverityEnum.values).map(severity -> {
            SingleValidationMessage svm = new SingleValidationMessage();
            svm.setMessage(MessageFormat.format("mock {0} message", severity.getCode()));
            svm.setSeverity(severity);
            return svm;
        }).toList();
        Mockito.when((Object)vr.getMessages()).thenReturn(errorMessages);
        return vr;
    }
}

