/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec.utils;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FhirTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FhirTest.class);
    protected FhirCodec fhirCodec;
    protected boolean printEncoded = false;
    protected boolean prettyPrint = false;
    protected EncodingType encodingType = EncodingType.XML;

    @BeforeEach
    void beforeEach() {
        this.initialize();
        if (this.fhirCodec == null) {
            this.fhirCodec = FhirCodec.forR4().andNonProfiledValidator();
        }
    }

    protected void initialize() {
    }

    protected ValidationResult encodeAndValidate(Resource resource) {
        String encoded = this.fhirCodec.encode((IBaseResource)resource, this.encodingType, this.prettyPrint);
        if (this.printEncoded) {
            this.printResource(encoded);
        }
        ValidationResult result = this.fhirCodec.validate(encoded);
        this.printValidationResult(result);
        return result;
    }

    protected void printResource(Resource resource) {
        String encoded = this.fhirCodec.encode((IBaseResource)resource, this.encodingType, this.prettyPrint);
        this.printResource(encoded);
    }

    protected void printResource(String resource) {
        System.out.println("\n##########\n" + resource + "\n##########\n");
    }

    protected void printValidationResult(ValidationResult result) {
        this.printValidationResult(result, m -> !m.getSeverity().equals((Object)ResultSeverityEnum.INFORMATION));
    }

    protected void printValidationResult(ValidationResult result, Predicate<SingleValidationMessage> messageFilter) {
        if (!result.isSuccessful()) {
            String r = result.getMessages().stream().filter(messageFilter).map(m -> MessageFormat.format("[{0} in Line {3} at {1}]: {2}", m.getSeverity(), m.getLocationString(), m.getMessage(), m.getLocationLine())).collect(Collectors.joining("\n\t"));
            log.warn("--- Found Validation Messages after validation: {} ---\n\t{}\n------", (Object)result.getMessages().stream().filter(messageFilter).count(), (Object)r);
        }
    }
}

